@extends('frontend.include.master')

@section('content')
    <div class="wrapper default">
        <div class="container">
            <div class="row">
                <div class="main-content col-12 col-md-7 col-lg-5 mx-auto">
                    <div class="account-box">
                        <a href="#" class="logo">
                            <img src="assets/img/logo.png" alt="">
                        </a>
                        <div class="account-box-title">ثبت نام در دیجی سایت</div>

                        @if(\Illuminate\Support\Facades\Session::has('danger'))
                            <div class="alert alert-danger">
                                {{session('danger')}}
                            </div>
                        @endif
                        <div class="account-box-content">

                            <form method="POST" action="{{ route('regUser') }}">
                                @csrf
                                <div class="form-account-title">نام را وارد کنید</div>
                                <div class="form-account-row">
                                    <label class="input-label"><i class="now-ui-icons users_single-02"></i></label>

                                    <input id="name" type="text" class="input-field @error('name') is-invalid @enderror"
                                           name="name" value="{{ old('name') }}" required autocomplete="name" autofocus
                                           placeholder="نام خود را وارد کنید">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror

                                </div>
                                <div class="row mb-3">
                                    <label for="email"
                                           class="col-md-4 col-form-label text-md-end">{{ __('Email Address') }}</label>

                                    <input id="email" type="email"
                                           class="input-field @error('email') is-invalid @enderror" name="email"
                                           value="{{ old('email') }}" required autocomplete="email">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="row mb-3">
                                    <label for="password"
                                           class="col-md-4 col-form-label text-md-end">{{ __('Password') }}</label>

                                    <input id="password" type="password"
                                           class="input-field @error('password') is-invalid @enderror" name="password"
                                           required autocomplete="new-password">

                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="row mb-3">
                                    <label for="password-confirm"
                                           class="col-md-4 col-form-label text-md-end">{{ __('Confirm Password') }}</label>

                                    <input id="password-confirm" type="password" class="input-field"
                                           name="password_confirmation" required autocomplete="new-password">
                                </div>
                                <div class="form-account-agree">
                                    <label class="checkbox-form checkbox-primary">
                                        <input type="checkbox" checked="checked">
                                        <span class="checkbox-check"></span>
                                    </label>
                                    <label for="agree">
                                        <a href="#" class="btn-link-border">حریم خصوصی</a> و <a href="#"
                                                                                                class="btn-link-border">شرایط
                                            و قوانین</a> استفاده از سرویس های سایت
                                        تاپ کالا را مطالعه نموده و با کلیه موارد آن موافقم.</label>
                                </div>
                                <div class="form-account-row form-account-submit">
                                    <div class="parent-btn">
                                        <button type="submit" class="dk-btn dk-btn-info">
                                            ثبت نام در دیجی سایت
                                            <i class="now-ui-icons users_circle-08"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="account-box-footer">
                            <span>قبلا در تاپ کالا ثبت‌نام کرده‌اید؟</span>
                            <a href="#" class="btn-link-border">وارد شوید</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection
